<?php

use App\Core\Router;
use App\Controllers\PageController;
use App\Controllers\SettingsController;
use App\Controllers\AiController;
use App\Controllers\FormController;
use App\Controllers\HostingController;
use App\Controllers\CheckoutController;
use App\Controllers\PlanController;
use App\Controllers\ErrorController;

$router = new Router();

$router->get('/', [PageController::class, 'home']);
$router->get('/domains', [PageController::class, 'domains']);
$router->get('/cloud', [PageController::class, 'cloud']);
$router->get('/cloud/hosting', [PageController::class, 'cloudHosting']);
$router->get('/cloud/business-hosting', [PageController::class, 'cloudBusinessHosting']);
$router->get('/cloud/woocommerce-hosting', [PageController::class, 'cloudWoo']);
$router->get('/cloud/wordpress-hosting', [PageController::class, 'cloudWp']);
$router->get('/quanta', [PageController::class, 'quanta']);
$router->get('/quanta-studio', [PageController::class, 'quantaStudio']);
$router->get('/solutions', [PageController::class, 'solutions']);
$router->get('/solutions/web-design', [PageController::class, 'solutionWeb']);
$router->get('/solutions/seo', [PageController::class, 'solutionSeo']);
$router->get('/solutions/app-development', [PageController::class, 'solutionApp']);
$router->get('/solutions/digital-ads', [PageController::class, 'solutionAds']);
$router->get('/solutions/wordpress-support', [PageController::class, 'solutionWp']);
$router->get('/pay', [PageController::class, 'pay']);
$router->get('/blog', [PageController::class, 'blog']);
$router->get('/blog/post', [PageController::class, 'blogPost']);
$router->get('/about', [PageController::class, 'about']);
$router->get('/contact', [PageController::class, 'contact']);
$router->get('/privacy', [PageController::class, 'privacy']);
$router->get('/terms', [PageController::class, 'terms']);
$router->get('/login', [PageController::class, 'login']);
$router->get('/signup', [PageController::class, 'signup']);
$router->get('/dashboard', [PageController::class, 'dashboard']);
$router->get('/quanta-chat', [PageController::class, 'quantaChat']);
$router->get('/plans', [PageController::class, 'plans']);
$router->get('/cart', [PageController::class, 'cart']);
$router->get('/checkout', [PageController::class, 'checkout']);
$router->get('/invoices', [PageController::class, 'invoices']);
$router->get('/support', [PageController::class, 'support']);
$router->get('/admin', [PageController::class, 'admin']);
$router->post('/locale', [SettingsController::class, 'setLocale']);
$router->post('/currency', [SettingsController::class, 'setCurrency']);
$router->post('/ai/domain-ideas', [AiController::class, 'domainIdeas']);
$router->post('/ai/quanta-chat', [AiController::class, 'quantaChat']);
$router->post('/form/contact', [FormController::class, 'contact']);
$router->post('/form/pay', [FormController::class, 'applyPay']);
$router->post('/form/custom-cloud', [FormController::class, 'customCloud']);
$router->post('/hosting/create', [HostingController::class, 'create']);
$router->post('/hosting/suspend', [HostingController::class, 'suspend']);
$router->post('/hosting/terminate', [HostingController::class, 'terminate']);
$router->post('/hosting/reset-password', [HostingController::class, 'resetPassword']);
$router->post('/pay/checkout', [CheckoutController::class, 'pay']);
$router->post('/ai/quanta-history', [AiController::class, 'quantaHistory']);
$router->post('/ai/quanta-create', [AiController::class, 'quantaCreate']);
$router->post('/ai/quanta-clear', [AiController::class, 'quantaClear']);
$router->post('/ai/memory-toggle', [AiController::class, 'memoryToggle']);
$router->post('/plan/set', [PlanController::class, 'set']);
$router->setNotFound([ErrorController::class, 'notFound']);

return $router;
