<?php

declare(strict_types=1);

session_start();

$uri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';
$path = rtrim($uri, '/') ?: '/';
$publicPath = __DIR__ . '/public' . $path;

// Serve static assets directly if they exist under public/.
if (is_file($publicPath)) {
    $mime = match (pathinfo($publicPath, PATHINFO_EXTENSION)) {
        'css' => 'text/css',
        'js' => 'application/javascript',
        'png' => 'image/png',
        'jpg', 'jpeg' => 'image/jpeg',
        'gif' => 'image/gif',
        'svg' => 'image/svg+xml',
        'ico' => 'image/x-icon',
        default => 'application/octet-stream',
    };
    header("Content-Type: {$mime}");
    readfile($publicPath);
    exit;
}

// Otherwise, route through the PHP router.
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $baseDir = __DIR__ . '/app/';
    if (str_starts_with($class, $prefix)) {
        $relative = str_replace('\\', '/', substr($class, strlen($prefix)));
        $file = $baseDir . $relative . '.php';
        if (file_exists($file)) {
            require $file;
        }
    }
});

require __DIR__ . '/app/helpers.php';

$router = require __DIR__ . '/routes/web.php';
$response = $router->dispatch($_SERVER['REQUEST_URI'], $_SERVER['REQUEST_METHOD']);
echo $response;
