<?php

if (!function_exists('__')) {
    function __(string $key, string $locale = null): string
    {
        static $cache = [];
        $locale = $locale ?: ($_SESSION['locale'] ?? 'en');
        $parts = explode('.', $key);
        $file = array_shift($parts);
        $path = __DIR__ . "/../resources/lang/{$locale}/{$file}.php";

        if (!isset($cache[$locale][$file])) {
            $cache[$locale][$file] = file_exists($path) ? include $path : [];
        }

        $value = $cache[$locale][$file];
        foreach ($parts as $part) {
            $value = $value[$part] ?? null;
        }

        return $value ?? $key;
    }
}

if (!function_exists('config')) {
    function config(string $key, mixed $default = null): mixed
    {
        static $cfg;
        if ($cfg === null) {
            $cfg = file_exists(__DIR__ . '/../config/app.php')
                ? include __DIR__ . '/../config/app.php'
                : [];
        }

        return $cfg[$key] ?? $default;
    }
}

if (!function_exists('json_ld')) {
    function json_ld(array $data): string
    {
        return '<script type="application/ld+json">' . json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) . '</script>';
    }
}

if (!function_exists('asset')) {
    function asset(string $path): string
    {
        $script = $_SERVER['SCRIPT_NAME'] ?? '';
        $base = rtrim(str_replace('\\', '/', dirname($script)), '/');
        $prefix = ($base === '' || $base === '.') ? '' : $base;
        // Serve assets from /assets/... so it works when docroot is repo root (index.php) or /public.
        return $prefix . '/' . ltrim($path, '/');
    }
}
