<section class="hero">
    <div class="glass card">
        <h1 class="section-title">Web Design Services</h1>
        <p class="muted">Packages for startup, business, enterprise, eCommerce, and custom — responsive, SEO-ready, performance-first.</p>
        <div class="flex gap-12">
            <a class="btn btn-primary" href="#packages">Request a Quote</a>
            <a class="btn btn-ghost" href="#process">See process</a>
        </div>
    </div>
</section>

<section id="packages" class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
    <?php foreach (['Startup', 'Business', 'Enterprise', 'eCommerce', 'Custom'] as $pkg): ?>
        <div class="glass card">
            <h3><?= $pkg ?></h3>
            <p class="muted">UX/UI, responsive layouts, speed, SEO schema, CMS handoff.</p>
            <ul>
                <li>Wireframes → visual design → dev → QA → launch</li>
                <li>Pages, components, animations, CMS setup</li>
                <li>Support & training options</li>
            </ul>
            <a class="btn btn-ghost" href="#cta">Request</a>
        </div>
    <?php endforeach; ?>
</section>

<section id="process" class="glass card">
    <h2 class="section-title">Process</h2>
    <ol>
        <li>Brief and requirements</li>
        <li>Wireframes and UX flows</li>
        <li>Visual design with iOS 26-inspired system</li>
        <li>Development (PHP/JS), QA, accessibility</li>
        <li>Launch, analytics, support</li>
    </ol>
    <p class="muted">Optional add-ons: copywriting, illustration, localization, ongoing CRO/experiments.</p>
</section>

<section class="glass card">
    <h2 class="section-title">Portfolio-style highlights</h2>
    <p class="muted">Carousel/grid of previous work, industry variety, testimonials.</p>
</section>

<section id="cta" class="glass card">
    <h2 class="section-title">Book a call</h2>
    <form class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 12px;">
        <input class="glass card" type="text" placeholder="Name">
        <input class="glass card" type="email" placeholder="Email">
        <input class="glass card" type="text" placeholder="Company">
        <textarea class="glass card" rows="3" placeholder="Project details"></textarea>
        <button class="btn btn-primary" type="submit">Send</button>
    </form>
    <p class="muted">Validation, spam protection, success/fail toasts.</p>
</section>
