<section class="hero">
    <div class="glass card">
        <h1 class="section-title">Solutions by Datanito</h1>
        <p class="muted">Web design, SEO, app development, digital advertising, WordPress premium support.</p>
        <p class="muted">Each solution includes discovery, execution, QA, launch, and ongoing support with analytics and reporting.</p>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
    <?php foreach ([
        'Web Design Services' => ['desc' => 'Packages for startup/business/enterprise/eCommerce/custom. Process from brief to launch.', 'url' => '/solutions/web-design'],
        'SEO Services' => ['desc' => 'On-page, off-page, technical, content, international SEO; tiers and case studies.', 'url' => '/solutions/seo'],
        'App Development' => ['desc' => 'Web/mobile/PWA with backend integration; industries and timelines.', 'url' => '/solutions/app-development'],
        'Digital Advertising' => ['desc' => 'Google/Meta ads, analytics, conversion tracking, reporting.', 'url' => '/solutions/digital-ads'],
        'WordPress Premium Support' => ['desc' => 'Maintenance, updates, backups, security, performance, emergency fixes.', 'url' => '/solutions/wordpress-support'],
    ] as $title => $data): ?>
        <div class="glass card">
            <h3><?= $title ?></h3>
            <p class="muted"><?= $data['desc'] ?></p>
            <a class="btn btn-ghost" href="<?= $data['url'] ?>"><?= $title ?> details</a>
        </div>
    <?php endforeach; ?>
</section>
