<section class="hero">
    <div class="glass card">
        <h1 class="section-title">Quanta AI — next-gen intelligence by Datanito</h1>
        <p class="muted">Models: Quanta 1, Quanta 1 Pro, Quanta 2 (Pro-tier) with memory, agents, and Gemini backend.</p>
        <div class="flex gap-12">
            <a class="btn btn-primary" href="/quanta-chat">Start Quanta Chat</a>
            <a class="btn btn-ghost" href="/plans">View plans</a>
        </div>
        <ul class="muted" style="margin-top: 10px;">
            <li>Memory controls: toggle, clear, view summaries.</li>
            <li>Agents: custom instructions, tone, goals, default model.</li>
            <li>Auto-naming chats, folders, and search with archiving.</li>
        </ul>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
    <?php foreach (['Quanta 1' => 'Reliable general assistant', 'Quanta 1 Pro' => 'Stronger, faster', 'Quanta 2' => 'Best for Pro/Business'] as $name => $desc): ?>
        <div class="glass card">
            <h3><?= $name ?></h3>
            <p class="muted"><?= $desc ?></p>
            <p class="muted">Memory, agents, high limits; upgrade prompts for Pro-only features.</p>
            <ul class="muted">
                <li>Latency targets and rate limits</li>
                <li>Safety filters and redaction where needed</li>
                <li>Supports code blocks and long-form answers</li>
            </ul>
        </div>
    <?php endforeach; ?>
</section>

<section class="glass card">
    <h2 class="section-title">Why Quanta</h2>
    <p class="muted">Comparisons vs generic chat tools: speed, UX polish, agent system, memory controls, safety.</p>
    <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));">
        <div class="glass card">Memory control, clear/disable</div>
        <div class="glass card">Agent creation with tone/goals</div>
        <div class="glass card">High limits for Pro users</div>
        <div class="glass card">Early access features</div>
        <div class="glass card">Workspace folders and chat search</div>
        <div class="glass card">Attachment support (docs/images planned)</div>
    </div>
</section>
