<section class="glass card" data-quanta-chat>
    <h1 class="section-title">Quanta Chat</h1>
    <p class="muted">Dedicated AI chat layout with sidebar, model selector, memory controls, agents, attachments, and plan-aware features.</p>
    <div class="glass card" style="margin-bottom: 12px;">
        <strong>What you can do</strong>
        <ul class="muted">
            <li>Switch models: Quanta 1 / 1 Pro / 2 (Pro/Business) with safety and rate limits by plan.</li>
            <li>Manage chats: auto-name, search, archive/delete/clear; folders to stay organized.</li>
            <li>Attachments: upload docs/images (summaries used server-side); future inline previews.</li>
            <li>Memory: toggle on/off, clear, view important facts; reminders to upgrade if limited.</li>
            <li>Agents: set defaults (tone, goals, model), reusable across chats; roadmap for sharing.</li>
            <li>Controls: light/dark mode, keyboard shortcuts (Enter send, Shift+Enter newline).</li>
        </ul>
    </div>
    <div class="grid" style="grid-template-columns: 260px 1fr; gap: 16px; min-height: 420px;">
        <aside class="glass card">
            <div class="muted">Chats, search, archive/delete/rename, folders.</div>
            <div class="flex gap-12" style="margin-top: 8px;">
                <button class="btn btn-primary" type="button" data-new-chat>New chat</button>
                <button class="btn btn-ghost" type="button" data-memory-toggle data-enabled="true">Memory: On</button>
            </div>
            <label class="muted" style="margin-top: 8px; display:block;">Plan</label>
            <select class="glass card" data-plan-set>
                <option value="free">Free</option>
                <option value="go">Go</option>
                <option value="plus">Plus</option>
                <option value="pro">Pro</option>
                <option value="business">Business</option>
            </select>
            <ul data-chat-list style="list-style: none; padding: 0; margin-top: 12px;">
                <li><button class="nav-link" data-chat-id="default" aria-current="true">Default chat</button></li>
            </ul>
        </aside>
        <div class="glass card">
            <div class="flex justify-between align-center">
                <div class="muted">
                    <label>Model</label>
                    <select class="glass card" data-chat-model>
                        <option value="quanta-1">Quanta 1</option>
                        <option value="quanta-1-pro">Quanta 1 Pro</option>
                        <option value="quanta-2">Quanta 2 (Pro/Business)</option>
                    </select>
                </div>
                <div class="muted">Settings • Memory toggle • Agent selection</div>
            </div>
            <div style="margin-top: 16px; min-height: 260px;" class="card" data-chat-messages>
                <p class="muted">Chat bubbles area; supports text/code/attachments; graceful error states.</p>
            </div>
            <div class="flex gap-12" style="margin-top: 12px; align-items: flex-start;">
                <div class="glass card" style="padding: 8px;">
                    <button class="btn btn-ghost" type="button" data-chat-more>More ▾</button>
                    <div class="glass card" data-chat-more-menu style="display:none; margin-top: 6px;">
                        <label class="nav-link" style="display:block; cursor:pointer;">
                            Upload image
                            <input type="file" accept="image/*" data-chat-image style="display:none;">
                        </label>
                        <label class="nav-link" style="display:block; cursor:pointer;">
                            Upload doc
                            <input type="file" accept=".pdf,.doc,.docx,.txt" data-chat-doc style="display:none;">
                        </label>
                        <button class="nav-link" type="button" data-chat-more-close>Close</button>
                    </div>
                </div>
                <textarea class="glass card" rows="3" style="flex:1;" placeholder="Send a message. Enter=send, Shift+Enter=new line." data-chat-input></textarea>
                <button class="btn btn-primary" type="button" data-chat-send>Send</button>
            </div>
        </div>
    </div>
</section>
