<section class="hero">
    <div class="glass card">
        <h1 class="section-title">Plans — Free, Go, Plus, Pro, Business</h1>
        <p class="muted">Compare limits, AI access, support, Pay commissions, and perks. Monthly/yearly pricing with currency selector.</p>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));">
    <?php foreach ([
        'Free' => 'Starter access, limited requests, memory cap.',
        'Go' => 'More requests, basic support.',
        'Plus' => 'Blue tick, better limits, Quanta 1 Pro access.',
        'Pro' => 'Blue tick, Quanta 2, higher limits, discounts.',
        'Business' => 'Yellow check, enterprise limits, priority SLAs.',
    ] as $plan => $desc): ?>
        <div class="glass card">
            <h3><?= $plan ?></h3>
            <p class="muted"><?= $desc ?></p>
            <ul>
                <li>Requests/day and context size</li>
                <li>Memory size and agent slots</li>
                <li>Support level & Pay commission discount</li>
                <li>Image generation via Gemini</li>
                <li>Billing: monthly/yearly, currency-aware pricing</li>
                <li>Verification badges on profile/chat/dashboard</li>
            </ul>
            <a class="btn btn-primary" href="/checkout">Choose</a>
        </div>
    <?php endforeach; ?>
</section>

<section class="glass card">
    <h2 class="section-title">Comparison table</h2>
    <div class="muted">Break down limits and perks per plan for quick scanning.</div>
    <table class="glass card" style="width:100%; margin-top: 8px;">
        <tr><th>Plan</th><th>Requests/day</th><th>Memory</th><th>Models</th><th>Support</th></tr>
        <tr><td>Free</td><td>Low</td><td>Small</td><td>Quanta 1</td><td>Community</td></tr>
        <tr><td>Go</td><td>Medium</td><td>Medium</td><td>Quanta 1</td><td>Standard</td></tr>
        <tr><td>Plus</td><td>Higher</td><td>More</td><td>Quanta 1, 1 Pro</td><td>Priority</td></tr>
        <tr><td>Pro</td><td>High</td><td>Large</td><td>Quanta 1/1 Pro/2</td><td>Fast priority</td></tr>
        <tr><td>Business</td><td>Custom</td><td>Custom</td><td>Quanta 2</td><td>Dedicated</td></tr>
    </table>
    <p class="muted">Toggle monthly/yearly and show Pay commission discounts (e.g., Plus -0.2%, Pro -0.4%, Business custom).</p>
</section>
