<section class="hero">
    <div class="glass card">
        <h1 class="section-title">Accept global payments with Datanito Pay</h1>
        <p class="muted">Visa, MasterCard, AmEx; security and compliance; multi-currency settlements.</p>
        <a class="btn btn-primary" href="#apply">Apply for Datanito Pay</a>
        <ul class="muted" style="margin-top: 10px;">
            <li>Onboarding: submit business info, KYC, expected volume.</li>
            <li>Settlement: payout schedules, fees per currency, reporting dashboards.</li>
            <li>Risk: fraud tools, 3DS support, chargeback guidance.</li>
        </ul>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
    <div class="glass card">
        <h3>Supported networks</h3>
        <p class="muted">Cards and alternative payments; show badges.</p>
        <p class="muted">Visa / MasterCard / AmEx; future wallets roadmap.</p>
    </div>
    <div class="glass card">
        <h3>Security & compliance</h3>
        <p class="muted">PCI, fraud tools, monitoring.</p>
        <p class="muted">IP whitelisting, webhook signing, activity logs.</p>
    </div>
    <div class="glass card">
        <h3>Fees & settlements</h3>
        <p class="muted">Multi-currency pricing, payout timelines, commissions per plan.</p>
        <p class="muted">Plan-based commission discounts (Plus/Pro/Business).</p>
    </div>
</section>

<section id="apply" class="hero">
    <div class="glass card">
        <h2 class="section-title">Application</h2>
        <p class="muted">Multi-step intake for business info, site, expected volume, KYC details.</p>
        <form class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: 12px;" method="post" action="/form/pay">
            <input class="glass card" type="text" name="business" placeholder="Business name" required>
            <input class="glass card" type="url" name="website" placeholder="Website URL" required>
            <input class="glass card" type="text" name="volume" placeholder="Expected monthly volume">
            <textarea class="glass card" name="kyc" placeholder="KYC details"></textarea>
            <input type="text" name="hp" value="" aria-hidden="true" style="display:none;">
            <button class="btn btn-primary" type="submit">Submit application</button>
        </form>
        <p class="muted">After submit: show confirmation; admin queue to Accept/Reject/Request info.</p>
    </div>
</section>
