<section class="hero">
    <div class="glass card">
        <h1 class="section-title">Invoices & Billing</h1>
        <p class="muted">List with status (Paid/Unpaid/Overdue), filters, currency, and automation notes.</p>
    </div>
</section>

<section class="glass card">
    <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
        <?php foreach (['Paid', 'Unpaid', 'Overdue'] as $status): ?>
            <div class="glass card">
                <h3>Invoice #<?= rand(1000, 9999) ?></h3>
                <p class="muted"><?= $status ?> · $199.00 · Due 2024-12-01</p>
                <div class="flex gap-12">
                    <a class="btn btn-ghost" href="#">PDF</a>
                    <?php if ($status !== 'Paid'): ?>
                        <a class="btn btn-primary" href="/checkout">Pay</a>
                    <?php endif; ?>
                </div>
                <p class="muted">Includes line items, taxes, and service references. Shows reminders and overdue notices.</p>
            </div>
        <?php endforeach; ?>
    </div>
    <p class="muted">Automation: cron to create before expiry, reminders by email/SMS (TR), overdue notices. Filters by status/date, search, and export to CSV/PDF.</p>
</section>
