<section class="hero">
    <div class="glass card">
        <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)); align-items: center;">
            <div>
                <div class="chip">iOS 26-inspired</div>
                <h1 class="section-title">Datanito — cloud, AI, payments, and domains in one calm experience.</h1>
                <p class="muted">Premium mobile-first UX with glass panels, deep AI, and WHM/cPanel automation.</p>
                <div class="flex gap-12" style="margin-top: 18px;">
                    <a class="btn btn-primary" href="/signup"><?= __('app.cta.start') ?></a>
                    <a class="btn btn-ghost" href="/contact"><?= __('app.cta.contact') ?></a>
                </div>
                <ul class="muted" style="margin-top: 14px;">
                    <li>Multilingual: TR / EN / DE / FR with currency-aware pricing.</li>
                    <li>Light/dark themes that stay crisp on mobile and desktop.</li>
                    <li>Global trust: uptime SLA, 24/7 support, verified payments.</li>
                </ul>
            </div>
            <div class="glass card">
                <p class="muted">Quick links</p>
                <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));">
                    <a class="nav-link" href="/domains">Domain search + AI ideas</a>
                    <a class="nav-link" href="/cloud">See cloud plans</a>
                    <a class="nav-link" href="/quanta">Try Quanta AI</a>
                    <a class="nav-link" href="/pay">Apply for Datanito Pay</a>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">Why Datanito</h2>
    <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));">
        <div class="glass card">
            <strong>Cloud built for reliability</strong>
            <p class="muted">SLA-backed uptime, WHM/cPanel automation, backups, and staging for safer launches.</p>
            <p class="muted">Status pages, proactive alerts, and guided incident response playbooks.</p>
        </div>
        <div class="glass card">
            <strong>AI everywhere</strong>
            <p class="muted">Quanta models for chat, agents, memory; AI domain ideas; auto-titles; content assist.</p>
            <p class="muted">Attachment-aware prompts (docs/images) and plan-gated Quanta 2 for pro teams.</p>
        </div>
        <div class="glass card">
            <strong>Payments and commerce</strong>
            <p class="muted">Datanito Pay for global cards, multi-currency checkout, invoicing, and renewals.</p>
            <p class="muted">Commission discounts for Plus/Pro/Business, payout schedules, and dispute guidance.</p>
        </div>
        <div class="glass card">
            <strong>International focus</strong>
            <p class="muted">Localized UX, currency-aware pricing, OTP for TR, email/Google login worldwide.</p>
            <p class="muted">Language toggle everywhere, region suggestions, and localized support SLAs.</p>
        </div>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));">
    <div class="glass card">
        <h2 class="section-title">Datanito Cloud</h2>
        <p class="muted">Hosting with WHM/cPanel automation, uptime guarantees, custom requests.</p>
        <a class="btn btn-ghost" href="/cloud">See hosting</a>
    </div>
    <div class="glass card">
        <h2 class="section-title">Quanta AI</h2>
        <p class="muted">Chat, agents, memory, powered by Gemini backend. Models: Quanta 1/Pro/2.</p>
        <a class="btn btn-ghost" href="/quanta">Explore Quanta</a>
    </div>
    <div class="glass card">
        <h2 class="section-title">Domains</h2>
        <p class="muted">Search, AI suggestions, transfer with auth code, history, favorites.</p>
        <a class="btn btn-ghost" href="/domains">Start search</a>
    </div>
    <div class="glass card">
        <h2 class="section-title">Datanito Pay</h2>
        <p class="muted">Accept Visa/Mastercard/AmEx; multi-currency; settlement + KYC flow.</p>
        <a class="btn btn-ghost" href="/pay">Apply now</a>
    </div>
</section>

<section class="hero">
    <div class="glass card">
        <h2 class="section-title">Plans preview</h2>
        <p class="muted">Free, Go, Plus, Pro, Business with verification badges and cross-product perks.</p>
        <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));">
            <?php foreach (['Free', 'Go', 'Plus', 'Pro', 'Business'] as $plan): ?>
                <div class="glass card">
                    <h3><?= $plan ?></h3>
                    <p class="muted">Limits, support level, AI access, Pay commission discount.</p>
                    <ul class="muted">
                        <li>Requests/day & context size</li>
                        <li>Memory size & agent slots</li>
                        <li>Support priority & badge</li>
                    </ul>
                    <a class="btn btn-ghost" href="/plans">Choose</a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">How it works</h2>
    <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));">
        <div class="glass card">
            <strong>1) Sign up</strong>
            <p class="muted">Pick language/currency, choose a plan (Free/Go/Plus/Pro/Business), verify email/OTP.</p>
        </div>
        <div class="glass card">
            <strong>2) Launch services</strong>
            <p class="muted">Register domains, order hosting, request Quanta access, or apply for Datanito Pay.</p>
        </div>
        <div class="glass card">
            <strong>3) Automate</strong>
            <p class="muted">Use dashboard for renewals, invoices, tickets, AI chats, and WHM/cPanel actions.</p>
        </div>
        <div class="glass card">
            <strong>4) Grow</strong>
            <p class="muted">Upgrade plans, enable memory/agents, expand regions, and add payment methods.</p>
        </div>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">Metrics that matter</h2>
    <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));">
        <div class="glass card">
            <strong>99.9%+</strong>
            <p class="muted">Uptime targets with SLA and status visibility.</p>
        </div>
        <div class="glass card">
            <strong>24/7</strong>
            <p class="muted">Support with ticketing, email, and regional coverage.</p>
        </div>
        <div class="glass card">
            <strong>Minutes</strong>
            <p class="muted">Average time to provision hosting and domains.</p>
        </div>
        <div class="glass card">
            <strong>Multi-currency</strong>
            <p class="muted">USD/EUR/TRY shown everywhere with updated rates.</p>
        </div>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">Testimonials & trust</h2>
    <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));">
        <div class="glass card">
            <p>“We moved all our WooCommerce stores to Datanito Cloud; support is instant and uptime is real.”</p>
            <p class="muted">Agency, EMEA</p>
        </div>
        <div class="glass card">
            <p>“Quanta AI is the first chat that feels enterprise-ready with controls we can hand to teams.”</p>
            <p class="muted">SaaS founder</p>
        </div>
        <div class="glass card">
            <p>“Datanito Pay simplified our onboarding for international cards with clear settlement rules.”</p>
            <p class="muted">Marketplace, EU</p>
        </div>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">FAQ</h2>
    <ul class="muted">
        <li><strong>Can I switch plans anytime?</strong> Yes, upgrades pro-rate and apply instantly to Quanta limits and Pay commissions.</li>
        <li><strong>Do you support migrations?</strong> Yes, guided migrations for hosting, DNS, and SSL.</li>
        <li><strong>Is AI data private?</strong> Prompts go server-side to Gemini; memory is user-controlled and can be cleared.</li>
        <li><strong>How do payments work?</strong> Pay via cards or Datanito Pay; invoices downloadable as PDF with reminders.</li>
    </ul>
</section>

<?php
$structured_data = [
    "@context" => "https://schema.org",
    "@type" => "Organization",
    "name" => "Datanito",
    "url" => "https://datanito.example",
    "description" => "Datanito — cloud hosting, AI, payments, and domains.",
    "contactPoint" => [
        "@type" => "ContactPoint",
        "contactType" => "customer service",
        "email" => "support@datanito.example",
        "areaServed" => ["TR", "EN", "DE", "FR"]
    ],
    "sameAs" => []
];
?>
