<section class="hero">
    <div class="glass card">
        <div class="grid" style="grid-template-columns: 1.2fr 0.8fr; gap: 24px;">
            <div>
                <h1 class="section-title">Find your perfect domain with AI</h1>
                <p class="muted">Search availability, get Gemini-powered ideas, save favorites, and add to cart instantly.</p>
                <p class="muted">Pricing adapts to USD/EUR/TRY, shows promos, and highlights renewal vs first-year costs.</p>
                <form class="grid" style="grid-template-columns: 1fr auto; gap: 12px; margin-top: 16px;" action="/domains" method="get">
                    <input class="glass card" type="search" name="q" placeholder="Search domains (e.g., datanito.com)" aria-label="Domain search">
                    <button class="btn btn-primary" type="submit">Search</button>
                </form>
                <div class="muted" style="margin-top: 12px;">Suggests TRY/USD/EUR pricing based on currency selector.</div>
            </div>
            <div class="glass card">
                <h3>AI domain assistant</h3>
                <textarea class="glass card" name="prompt" placeholder="Describe your idea, brand, industry" rows="4" data-ai-prompt></textarea>
                <div class="flex gap-12" style="margin-top: 10px;">
                    <button class="btn btn-primary" type="button" data-ai-generate>Generate ideas</button>
                    <button class="btn btn-ghost" type="button" data-ai-regenerate>Regenerate</button>
                </div>
                <p class="muted">Backend: call Gemini with idea → TLD mix, short names, variants; handle retry and fallback.</p>
                <div class="glass card" style="margin-top: 10px;" data-ai-results></div>
            </div>
        </div>
    </div>
</section>

<section class="glass card">
    <div class="flex gap-12 align-center" role="tablist">
        <button class="btn btn-ghost" role="tab" aria-selected="true">Find</button>
        <button class="btn btn-ghost" role="tab">History</button>
        <button class="btn btn-ghost" role="tab">Fav</button>
    </div>
    <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)); margin-top: 12px;">
        <?php for ($i = 0; $i < 4; $i++): ?>
            <div class="glass card">
                <div class="flex justify-between align-center">
                    <div>
                        <strong>datanito<?= $i ?>.com</strong>
                        <p class="muted">Available &middot; $9.99/yr</p>
                    </div>
                    <div class="flex gap-12 align-center">
                        <button class="btn btn-primary" type="button">Add to cart</button>
                        <button class="btn btn-ghost" type="button">♡</button>
                    </div>
                </div>
                <div class="muted">Promo badge, alt TLDs: .ai .net .org</div>
                <ul class="muted">
                    <li>DNS management link and WHOIS privacy toggle</li>
                    <li>Auto-renew switch with reminder emails</li>
                    <li>Transfer-in CTA if domain is taken</li>
                </ul>
            </div>
        <?php endfor; ?>
    </div>
    <div class="glass card" style="margin-top: 12px;">
        <h3>History</h3>
        <p class="muted">Logged-in users see recent searches with re-search, favorite, add to cart.</p>
        <p class="muted">Includes time stamps, currency used, and quick “add all to cart”.</p>
    </div>
    <div class="glass card" style="margin-top: 12px;">
        <h3>Favorites</h3>
        <p class="muted">Fav list with add/remove, compare, and add to cart actions.</p>
        <p class="muted">Side-by-side comparison table for price, TLD, renewal cost, and badges.</p>
    </div>
</section>

<section class="hero">
    <div class="glass card">
        <h2 class="section-title">Transfer your domain</h2>
        <p class="muted">Simple transfer form with auth code and status tracking.</p>
        <form class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 12px;">
            <input class="glass card" type="text" name="domain" placeholder="yourdomain.com" required>
            <input class="glass card" type="text" name="registrar" placeholder="Current registrar">
            <input class="glass card" type="text" name="authcode" placeholder="Auth/EPP code" required>
            <textarea class="glass card" name="notes" placeholder="Notes (optional)"></textarea>
            <button class="btn btn-primary" type="submit">Start transfer</button>
        </form>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">FAQ</h2>
    <p class="muted">Use FAQPage structured data; cover registration, transfers, DNS timing, promos.</p>
    <ul>
        <li>How long does registration/transfer take?</li>
        <li>What is the renewal pricing and promo rules?</li>
        <li>How to manage DNS?</li>
    </ul>
</section>

<section class="glass card">
    <h2 class="section-title">Long-form content</h2>
    <p class="muted">SEO block on TLDs, best practices, branding tips, and transfer benefits for Datanito. Include structured data and internal links to hosting and pay products.</p>
    <ul class="muted">
        <li>Choosing TLDs for region vs global presence</li>
        <li>Checklist for brandability and pronunciation</li>
        <li>DNS propagation basics and TTL guidance</li>
        <li>Security: DNSSEC, WHOIS privacy, renewal reminders</li>
        <li>Why transfer to Datanito: unified billing, support, DNS tools</li>
    </ul>
</section>

<?php
$structured_data = [
    "@context" => "https://schema.org",
    "@type" => "FAQPage",
    "mainEntity" => [
        [
            "@type" => "Question",
            "name" => "How long does registration/transfer take?",
            "acceptedAnswer" => [
                "@type" => "Answer",
                "text" => "Most registrations are near-instant; transfers depend on registrar and usually take a few days."
            ]
        ],
        [
            "@type" => "Question",
            "name" => "What is the renewal pricing and promo rules?",
            "acceptedAnswer" => [
                "@type" => "Answer",
                "text" => "Renewal pricing follows the posted rates; promos apply to first term only unless stated."
            ]
        ],
        [
            "@type" => "Question",
            "name" => "How to manage DNS?",
            "acceptedAnswer" => [
                "@type" => "Answer",
                "text" => "DNS management is available in the dashboard with records editing and propagation guidance."
            ]
        ],
    ]
];
?>
