<section class="hero">
    <div class="glass card">
        <h1 class="section-title">Datanito Cloud — scalable, premium hosting</h1>
        <p class="muted">SLA-backed uptime, WHM/cPanel automation, and custom cloud requests for demanding teams.</p>
        <div class="flex gap-12" style="margin-top: 12px;">
            <a class="btn btn-primary" href="/cloud/hosting">See hosting plans</a>
            <a class="btn btn-ghost" href="#custom-cloud">Request custom cloud</a>
        </div>
        <ul class="muted" style="margin-top: 12px;">
            <li>Regions: choose nearest POPs, CDN-friendly.</li>
            <li>Security: WAF, DDoS mitigation, backups, staging.</li>
            <li>Compliance: GDPR-friendly handling, audit trails, activity logs.</li>
        </ul>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
    <div class="glass card">
        <h3>Infrastructure</h3>
        <p class="muted">Reliability, security, compliance, backups, DDoS protection.</p>
        <p class="muted">NVMe storage, HTTP/2, PHP 8.x, managed SSL, free migration.</p>
        <p class="muted">Monitoring with alerts, performance analytics, and guided remediation.</p>
    </div>
    <div class="glass card">
        <h3>Comparison</h3>
        <p class="muted">How we differ from generic hosting: performance, SLAs, human support.</p>
        <p class="muted">Transparent resource allocations and burst guidance.</p>
    </div>
    <div class="glass card">
        <h3>Use cases</h3>
        <p class="muted">By industry: ecommerce, SaaS, agencies, media.</p>
        <p class="muted">Showcase specific stacks: WooCommerce, WordPress, Laravel, headless CMS.</p>
    </div>
    <div class="glass card">
        <h3>Trust & SLA</h3>
        <p class="muted">99.9%+ uptime, RTO/RPO targets, incident response runbooks, backup restore drills.</p>
    </div>
</section>

<section id="custom-cloud" class="hero">
    <div class="glass card">
        <h2 class="section-title">Custom cloud request</h2>
        <p class="muted">Multi-step intake: company info, traffic, resources, compliance.</p>
        <form class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: 12px;" method="post" action="/form/custom-cloud">
            <input class="glass card" type="text" name="company" placeholder="Company" required>
            <input class="glass card" type="email" name="contact" placeholder="Contact email" required>
            <input class="glass card" type="text" name="traffic" placeholder="Traffic expectations">
            <textarea class="glass card" name="needs" placeholder="Resources and compliance needs"></textarea>
            <input type="text" name="hp" value="" aria-hidden="true" style="display:none;">
            <button class="btn btn-primary" type="submit">Submit request</button>
        </form>
        <p class="muted">After submit: show pending evaluation; admin can review and reply.</p>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">Subpages</h2>
    <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));">
        <?php foreach ([
            'Web Hosting' => '/cloud/hosting',
            'Business Web Hosting' => '/cloud/business-hosting',
            'WooCommerce Web Hosting' => '/cloud/woocommerce-hosting',
            'WordPress Web Hosting' => '/cloud/wordpress-hosting'
        ] as $page => $url): ?>
            <div class="glass card">
                <h3><?= $page ?></h3>
                <p class="muted">Plan cards, SLA, backups, pricing toggle, CTA to order/contact.</p>
                <a class="btn btn-ghost" href="<?= $url ?>">Open</a>
                <p class="muted">Includes industry use cases, FAQ, and comparison tables.</p>
            </div>
        <?php endforeach; ?>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">FAQ & long-form</h2>
    <ul class="muted">
        <li>Which plan fits my traffic profile? Guidance by monthly visits and resource caps.</li>
        <li>How backups work: cadence, retention, restores, and testing.</li>
        <li>Security posture: WAF, malware scans, least-privilege access, audit logs.</li>
        <li>Migration steps: DNS cutover, SSL reissue, rollback plan.</li>
    </ul>
</section>
