<section class="hero">
    <div class="glass card">
        <h1 class="section-title">WordPress Web Hosting</h1>
        <p class="muted">Managed WordPress hosting with staging, backups, security hardening, and performance tuning.</p>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
    <?php foreach (['WP Starter', 'WP Plus', 'WP Pro'] as $plan): ?>
        <div class="glass card">
            <h3><?= $plan ?></h3>
            <p class="muted">Caching, CDN-ready, updates, monitoring, SLA-backed support.</p>
            <div class="flex gap-12">
                <a class="btn btn-primary" href="/cart">Order</a>
                <a class="btn btn-ghost" href="/contact">Contact sales</a>
            </div>
            <ul class="muted">
                <li>One-click staging and rollbacks</li>
                <li>Managed plugin/theme updates</li>
                <li>Security hardening and WAF options</li>
            </ul>
        </div>
    <?php endforeach; ?>
</section>

<section class="glass card">
    <h2 class="section-title">FAQ</h2>
    <p class="muted">Updates policy, plugin restrictions, staging flow, backup cadence.</p>
    <ul class="muted">
        <li>Supported cache configs and CDN recommendations.</li>
        <li>Security hardening steps and plugin/theme vetting.</li>
        <li>Disaster recovery playbook and SLA windows.</li>
    </ul>
</section>
