<section class="hero">
    <div class="glass card">
        <h1 class="section-title">WooCommerce Web Hosting</h1>
        <p class="muted">Optimized for WooCommerce with caching, CDN-ready, and uptime SLAs.</p>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
    <?php foreach (['Woo Starter', 'Woo Plus', 'Woo Pro'] as $plan): ?>
        <div class="glass card">
            <h3><?= $plan ?></h3>
            <p class="muted">Performance tuning, image/CDN setup, backups, priority support.</p>
            <div class="flex gap-12">
                <a class="btn btn-primary" href="/cart">Order</a>
                <a class="btn btn-ghost" href="/contact">Contact sales</a>
            </div>
            <ul class="muted">
                <li>Checkout hardening and uptime SLAs</li>
                <li>Cache/CDN presets for WooCommerce</li>
                <li>Order/payout monitoring hooks</li>
            </ul>
        </div>
    <?php endforeach; ?>
</section>

<section class="glass card">
    <h2 class="section-title">Comparison</h2>
    <p class="muted">Speed vs generic hosts, cart/checkout reliability, PCI-aligned practices.</p>
    <p class="muted">Checkout hardening checklist, uptime targets during sales peaks, and real-time monitoring.</p>
</section>
