<section class="hero">
    <div class="glass card">
        <h1 class="section-title">Web Hosting</h1>
        <p class="muted">Starter to Pro plans with SSL, backups, and WHM/cPanel automation.</p>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
    <?php foreach (['Starter', 'Plus', 'Pro'] as $plan): ?>
        <div class="glass card">
            <h3><?= $plan ?></h3>
            <p class="muted">Resources, email accounts, SSL, backups, support SLA.</p>
            <div class="flex gap-12">
                <a class="btn btn-primary" href="/cart">Order</a>
                <a class="btn btn-ghost" href="/contact">Contact sales</a>
            </div>
            <ul class="muted">
                <li>Staging, backups, PHP version control</li>
                <li>cPanel access and migration support</li>
                <li>Monitoring and alerts</li>
            </ul>
        </div>
    <?php endforeach; ?>
</section>

<section class="glass card">
    <h2 class="section-title">FAQ & comparison</h2>
    <p class="muted">Performance metrics, uptime guarantees, vs normal hosting chart.</p>
    <ul class="muted">
        <li>When to upgrade plans based on CPU/RAM usage.</li>
        <li>How staging and backups interact; restore guidance.</li>
        <li>Email deliverability and DNS records best practices.</li>
    </ul>
</section>
