<section class="hero">
    <div class="glass card">
        <h1 class="section-title">Business Web Hosting</h1>
        <p class="muted">For teams needing higher performance, priority support, compliance options.</p>
    </div>
</section>

<section class="grid" style="grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));">
    <?php foreach (['Business', 'Business Plus', 'Business Pro'] as $plan): ?>
        <div class="glass card">
            <h3><?= $plan ?></h3>
            <p class="muted">More CPU/RAM, backups, SLAs, staging, priority tickets.</p>
            <div class="flex gap-12">
                <a class="btn btn-primary" href="/cart">Order</a>
                <a class="btn btn-ghost" href="/contact">Contact sales</a>
            </div>
            <ul class="muted">
                <li>White-glove migration</li>
                <li>Compliance options (logs, access controls)</li>
                <li>Performance tuning for busy sites</li>
            </ul>
        </div>
    <?php endforeach; ?>
</section>

<section class="glass card">
    <h2 class="section-title">Use cases</h2>
    <p class="muted">Agencies, media sites, SaaS marketing, B2B portals.</p>
    <p class="muted">Notes on concurrency, caching strategies, and access control per team.</p>
</section>
