<section class="hero">
    <div class="glass card fade-in" style="text-align:center;">
        <div class="chip">404</div>
        <h1 class="section-title">Lost in Datanito</h1>
        <p class="muted">We couldn’t find the page you’re looking for. Let’s get you back on track.</p>
        <p class="muted">Missing path: <code><?= htmlspecialchars($missing_path ?? '') ?></code></p>
        <div class="flex gap-12" style="justify-content:center; margin-top: 12px;">
            <a class="btn btn-primary" href="/">Go Home</a>
            <a class="btn btn-ghost" href="/contact">Contact support</a>
        </div>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">Quick actions</h2>
    <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));">
        <a class="glass card nav-link" href="/domains">Search domains</a>
        <a class="glass card nav-link" href="/cloud">View cloud plans</a>
        <a class="glass card nav-link" href="/quanta">Open Quanta AI</a>
        <a class="glass card nav-link" href="/pay">Apply for Datanito Pay</a>
    </div>
</section>

<section class="glass card">
    <h2 class="section-title">Tell us what happened</h2>
    <p class="muted">Report the missing page and we’ll investigate.</p>
    <form id="report-404" class="grid" style="grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 12px;">
        <input class="glass card" type="text" name="name" placeholder="Name" required>
        <input class="glass card" type="email" name="email" placeholder="Email" required>
        <input class="glass card" type="text" name="region" placeholder="Region">
        <textarea class="glass card" name="message" rows="3" placeholder="What were you looking for?" required></textarea>
        <input type="hidden" name="path" value="<?= htmlspecialchars($missing_path ?? '') ?>">
        <input type="text" name="hp" value="" aria-hidden="true" style="display:none;">
        <button class="btn btn-primary" type="submit">Send report</button>
    </form>
    <div id="report-404-status" class="muted" style="margin-top: 8px;"></div>
</section>

<script>
$(function() {
    $('#report-404').on('submit', function(e) {
        e.preventDefault();
        const $status = $('#report-404-status');
        $status.text('Sending...');
        const data = $(this).serialize() + '&interest=Support';
        $.ajax({
            url: '/form/contact',
            type: 'POST',
            data,
            success: function(resp) {
                if (resp && resp.status === 'ok') {
                    $status.text('Thanks! We received your report.');
                } else {
                    $status.text('Could not send right now. Please try again.');
                }
            },
            error: function() {
                $status.text('Error sending report. Please try again.');
            }
        });
    });
});
</script>
