<?php
    $locale = $_SESSION['locale'] ?? config('default_locale', 'en');
    $currency = $_SESSION['currency'] ?? config('default_currency', 'USD');
    $currencies = config('supported_currencies', ['USD']);
    $locales = config('supported_locales', ['en']);
    $pageTitle = $title ?? __('app.brand');
    $metaDescription = $meta_description ?? 'Datanito — cloud, AI, payments, and domains in a premium iOS-inspired experience.';
    $themeDefault = config('theme_default', 'auto');
?>
<!doctype html>
<html lang="<?= htmlspecialchars($locale) ?>" data-theme="<?= htmlspecialchars($themeDefault) ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= htmlspecialchars($pageTitle) ?></title>
    <meta name="description" content="<?= htmlspecialchars($metaDescription) ?>">
    <meta property="og:title" content="<?= htmlspecialchars($pageTitle) ?>">
    <meta property="og:description" content="<?= htmlspecialchars($metaDescription) ?>">
    <meta property="og:site_name" content="<?= __('app.brand') ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flowbite@2.5.1/dist/flowbite.min.css">
    <link rel="stylesheet" href="<?= asset('assets/css/app.css') ?>">
</head>
<body>
    <header class="header glass" role="banner">
        <div class="shell flex justify-between align-center gap-12">
            <div class="flex align-center gap-12">
                <div class="glass card" style="padding: 10px 14px; display:flex; align-items:center; gap:10px;">
                    <a class="chip" href="/"><?= __('app.brand') ?></a>
                    <?php if (!empty($section_tag)): ?>
                        <span class="pill"><?= htmlspecialchars($section_tag) ?></span>
                    <?php endif; ?>
                </div>
                <button class="btn btn-ghost mobile-only" type="button" data-menu-toggle>Menu</button>
                <nav class="flex align-center gap-12 desktop-only" aria-label="Main navigation">
                    <a class="nav-link" href="/"><?= __('app.nav.home') ?></a>
                    <div class="mega-trigger">
                        <a class="nav-link" href="/cloud"><?= __('app.nav.cloud') ?></a>
                        <div class="glass card mega-panel">
                            <div class="mega-grid">
                                <div>
                                    <strong>Cloud products</strong>
                                    <ul class="muted" style="list-style:none;padding:0;margin:8px 0 0;">
                                        <li><a class="nav-link" href="/cloud/hosting">Web Hosting</a></li>
                                        <li><a class="nav-link" href="/cloud/business-hosting">Business Hosting</a></li>
                                        <li><a class="nav-link" href="/cloud/woocommerce-hosting">WooCommerce Hosting</a></li>
                                        <li><a class="nav-link" href="/cloud/wordpress-hosting">WordPress Hosting</a></li>
                                        <li><a class="nav-link" href="/cloud#custom-cloud">Custom Cloud</a></li>
                                    </ul>
                                </div>
                                <div>
                                    <strong>Key features</strong>
                                    <ul class="muted" style="list-style:none;padding:0;margin:8px 0 0;">
                                        <li>WHM/cPanel automation</li>
                                        <li>SLA uptime, backups, staging</li>
                                        <li>Security, WAF, DDoS protection</li>
                                    </ul>
                                </div>
                                <div>
                                    <strong>Get started</strong>
                                    <ul class="muted" style="list-style:none;padding:0;margin:8px 0 0;">
                                        <li><a class="nav-link" href="/cloud">Overview</a></li>
                                        <li><a class="nav-link" href="/contact">Talk to sales</a></li>
                                        <li><a class="nav-link" href="/plans">Compare plans</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mega-trigger">
                        <a class="nav-link" href="/quanta"><?= __('app.nav.quanta') ?></a>
                        <div class="glass card mega-panel">
                            <div class="mega-grid">
                                <div>
                                    <strong>Quanta AI</strong>
                                    <ul class="muted" style="list-style:none;padding:0;margin:8px 0 0;">
                                        <li><a class="nav-link" href="/quanta">Models overview</a></li>
                                        <li><a class="nav-link" href="/quanta-chat">Quanta Chat</a></li>
                                        <li><a class="nav-link" href="/quanta-studio">Quanta Studio</a></li>
                                    </ul>
                                </div>
                                <div>
                                    <strong>Capabilities</strong>
                                    <ul class="muted" style="list-style:none;padding:0;margin:8px 0 0;">
                                        <li>Memory controls</li>
                                        <li>Agents and tone settings</li>
                                        <li>Attachments (docs/images)</li>
                                    </ul>
                                </div>
                                <div>
                                    <strong>Upgrade</strong>
                                    <ul class="muted" style="list-style:none;padding:0;margin:8px 0 0;">
                                        <li><a class="nav-link" href="/plans">Plans (Free → Business)</a></li>
                                        <li>Quanta 2 for Pro/Business</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a class="nav-link" href="/domains"><?= __('app.nav.domains') ?></a>
                    <a class="nav-link" href="/solutions"><?= __('app.nav.solutions') ?></a>
                    <a class="nav-link" href="/pay"><?= __('app.nav.pay') ?></a>
                    <a class="nav-link" href="/blog"><?= __('app.nav.blog') ?></a>
                    <a class="nav-link" href="/plans"><?= __('app.nav.plans') ?></a>
                </nav>
            </div>
            <div class="flex align-center gap-12">
                <button class="btn btn-ghost" type="button" data-open-settings>Settings</button>
                <button class="btn btn-ghost" type="button" data-open-cart>Cart</button>
                <button class="btn btn-ghost" type="button" data-open-account>Account</button>
                <a class="btn btn-ghost" href="/login"><?= __('app.nav.login') ?></a>
                <a class="btn btn-primary" href="/signup"><?= __('app.nav.signup') ?></a>
            </div>
        </div>
        <div class="shell mobile-only" style="padding-top: 8px;">
            <nav class="flex align-center gap-12" aria-label="Main navigation" data-main-nav-mobile>
                <a class="nav-link" href="/"><?= __('app.nav.home') ?></a>
                <a class="nav-link" href="/domains"><?= __('app.nav.domains') ?></a>
                <a class="nav-link" href="/cloud"><?= __('app.nav.cloud') ?></a>
                <a class="nav-link" href="/quanta"><?= __('app.nav.quanta') ?></a>
                <a class="nav-link" href="/quanta-studio"><?= __('app.nav.quanta_studio') ?></a>
                <a class="nav-link" href="/solutions"><?= __('app.nav.solutions') ?></a>
                <a class="nav-link" href="/pay"><?= __('app.nav.pay') ?></a>
                <a class="nav-link" href="/blog"><?= __('app.nav.blog') ?></a>
                <a class="nav-link" href="/plans"><?= __('app.nav.plans') ?></a>
            </nav>
        </div>
    </header>
    <main class="shell fade-in">
        <?= $content ?>
    </main>
    <footer class="shell muted" role="contentinfo">
        <div class="glass card footer-grid">
            <div>
                <div class="chip"><?= __('app.brand') ?></div>
                <?php if (!empty($section_tag)): ?>
                    <p class="muted">You’re in <strong><?= htmlspecialchars($section_tag) ?></strong>. Switch anytime from the header.</p>
                <?php else: ?>
                    <p class="muted">Cloud, AI, Pay, Domains, and support in one calm experience.</p>
                <?php endif; ?>
                <div class="flex gap-12" style="margin-top: 8px;">
                    <select class="toggle" data-locale-switch aria-label="Select language">
                        <?php foreach ($locales as $lang): ?>
                            <option value="<?= $lang ?>" <?= $lang === $locale ? 'selected' : '' ?>><?= strtoupper($lang) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <select class="toggle" data-currency-switch aria-label="Select currency">
                        <?php foreach ($currencies as $curr): ?>
                            <option value="<?= $curr ?>" <?= $curr === $currency ? 'selected' : '' ?>><?= $curr ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div>
                <strong>Products</strong>
                <ul class="muted" style="list-style:none; padding:0; margin-top:8px;">
                    <li><a href="/cloud">Datanito Cloud</a></li>
                    <li><a href="/quanta">Quanta AI</a></li>
                    <li><a href="/pay">Datanito Pay</a></li>
                    <li><a href="/domains">Domains</a></li>
                    <li><a href="/solutions">Solutions</a></li>
                </ul>
            </div>
            <div>
                <strong>Company</strong>
                <ul class="muted" style="list-style:none; padding:0; margin-top:8px;">
                    <li><a href="/about">About</a></li>
                    <li><a href="/blog">Blog</a></li>
                    <li><a href="/contact">Contact</a></li>
                    <li><a href="/support">Support</a></li>
                </ul>
            </div>
            <div>
                <strong>Legal</strong>
                <ul class="muted" style="list-style:none; padding:0; margin-top:8px;">
                    <li><a href="/privacy">Privacy</a></li>
                    <li><a href="/terms">Terms</a></li>
                    <li><a href="/plans">Plans</a></li>
                    <li><a href="/checkout">Checkout</a></li>
                </ul>
            </div>
        </div>
        <div class="muted" style="text-align:center; padding: 12px 0;">
            <?= __('app.brand') ?> &mdash; <?= __('app.footer.rights') ?>
        </div>
    </footer>
    <div class="modal-overlay" data-modal-overlay></div>
    <div class="modal" data-settings-modal>
        <div class="modal-content glass">
            <div class="flex justify-between align-center" style="margin-bottom: 8px;">
                <h3>Settings</h3>
                <button class="btn btn-ghost" data-close-settings type="button">Close</button>
            </div>
            <div class="grid" style="grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 10px;">
                <div>
                    <label class="muted">Language</label>
                    <select class="toggle" data-locale-switch aria-label="Select language">
                        <?php foreach ($locales as $lang): ?>
                            <option value="<?= $lang ?>" <?= $lang === $locale ? 'selected' : '' ?>><?= strtoupper($lang) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="muted">Currency</label>
                    <select class="toggle" data-currency-switch aria-label="Select currency">
                        <?php foreach ($currencies as $curr): ?>
                            <option value="<?= $curr ?>" <?= $curr === $currency ? 'selected' : '' ?>><?= $curr ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="muted">Theme</label>
                    <button class="toggle" data-theme-toggle type="button">Theme</button>
                </div>
            </div>
        </div>
    </div>
    <div class="drawer" data-cart-drawer>
        <div class="flex justify-between align-center">
            <h3>Cart</h3>
            <button class="btn btn-ghost" data-close-drawer type="button">Close</button>
        </div>
        <p class="muted">Quick cart drawer for items across domains, hosting, and AI.</p>
        <a class="btn btn-primary" href="/cart">View cart</a>
    </div>
    <div class="drawer" data-account-drawer>
        <div class="flex justify-between align-center">
            <h3>Account</h3>
            <button class="btn btn-ghost" data-close-drawer type="button">Close</button>
        </div>
        <p class="muted">Profile summary, dashboard, invoices, tickets.</p>
        <a class="btn btn-primary" href="/dashboard">Open dashboard</a>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/flowbite@2.5.1/dist/flowbite.min.js"></script>
    <script src="<?= asset('assets/js/app.js') ?>"></script>
    <?php if (!empty($structured_data)): ?>
        <?= json_ld($structured_data) ?>
    <?php endif; ?>
</body>
</html>
