<?php

namespace App\Services;

class PayService
{
    private string $apiUrl;
    private string $apiKey;

    public function __construct()
    {
        $this->apiUrl = getenv(config('pay_api_url_env', 'DATANITO_PAY_API_URL')) ?: '';
        $this->apiKey = getenv(config('pay_api_key_env', 'DATANITO_PAY_API_KEY')) ?: '';
    }

    public function initiatePayment(array $payload): array
    {
        if (!$this->apiUrl || !$this->apiKey) {
            return ['status' => 'queued', 'message' => 'Payment request created (stub)', 'id' => uniqid('pay_', true)];
        }

        $ch = curl_init($this->apiUrl);
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $this->apiKey,
            ],
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_TIMEOUT => 15,
        ]);
        $raw = curl_exec($ch);
        $err = curl_error($ch);
        $status = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
        curl_close($ch);

        if ($err) {
            return ['status' => 'error', 'message' => $err];
        }
        if ($status >= 400) {
            return ['status' => 'error', 'message' => 'Pay API HTTP ' . $status, 'raw' => $raw];
        }
        $json = json_decode($raw, true);
        return $json ?: ['status' => 'ok', 'raw' => $raw];
    }
}
