<?php

namespace App\Controllers;

class SettingsController extends BaseController
{
    public function setLocale(): string
    {
        $locale = $_POST['locale'] ?? config('default_locale', 'en');
        $allowed = config('supported_locales', ['en']);
        if (!in_array($locale, $allowed, true)) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Invalid locale']);
        }
        $_SESSION['locale'] = $locale;
        header('Content-Type: application/json');
        return json_encode(['status' => 'ok', 'locale' => $locale]);
    }

    public function setCurrency(): string
    {
        $currency = $_POST['currency'] ?? config('default_currency', 'USD');
        $allowed = config('supported_currencies', ['USD']);
        if (!in_array($currency, $allowed, true)) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Invalid currency']);
        }
        $_SESSION['currency'] = $currency;
        header('Content-Type: application/json');
        return json_encode(['status' => 'ok', 'currency' => $currency]);
    }
}
