<?php

namespace App\Controllers;

class PlanController extends BaseController
{
    private array $plans = ['free', 'go', 'plus', 'pro', 'business'];

    public function set(): string
    {
        $plan = strtolower($_POST['plan'] ?? 'free');
        if (!in_array($plan, $this->plans, true)) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Invalid plan']);
        }
        $_SESSION['plan'] = $plan;
        return json_encode(['status' => 'ok', 'plan' => $plan]);
    }
}
