<?php

namespace App\Controllers;

class PageController extends BaseController
{
    public function home(): string
    {
        return $this->view('pages/home', [
            'title' => 'Datanito — iOS 26-inspired cloud, AI, pay, domains',
            'meta_description' => 'Datanito blends cloud hosting, AI (Quanta), domains, and payments in a mobile-first glass UI.',
            'section_tag' => null,
        ]);
    }

    public function domains(): string
    {
        return $this->view('pages/domains', [
            'title' => 'Domains — search, AI ideas, transfer',
            'meta_description' => 'Search domains, get AI suggestions, manage favorites, and transfer with auth code at Datanito.',
            'section_tag' => 'Domains',
        ]);
    }

    public function cloud(): string
    {
        return $this->view('pages/cloud', [
            'title' => 'Datanito Cloud — hosting and custom cloud',
            'meta_description' => 'Premium WHM/cPanel hosting with SLA and custom cloud requests across industries.',
            'section_tag' => 'Cloud',
        ]);
    }

    public function quanta(): string
    {
        return $this->view('pages/quanta', [
            'title' => 'Quanta AI — next-gen intelligence',
            'meta_description' => 'Quanta AI models (1, 1 Pro, 2) with memory, agents, and Gemini backend. Start Quanta Chat.',
            'section_tag' => 'Quanta AI',
        ]);
    }

    public function cloudHosting(): string
    {
        return $this->view('pages/cloud-web-hosting', [
            'title' => 'Web Hosting — Datanito Cloud',
            'meta_description' => 'Starter to Pro WHM/cPanel hosting with SSL, backups, SLAs, and order flows.',
            'section_tag' => 'Cloud',
        ]);
    }

    public function cloudBusinessHosting(): string
    {
        return $this->view('pages/cloud-business-hosting', [
            'title' => 'Business Web Hosting — Datanito Cloud',
            'meta_description' => 'Business-grade hosting with priority support, staging, and compliance options.',
            'section_tag' => 'Cloud',
        ]);
    }

    public function cloudWoo(): string
    {
        return $this->view('pages/cloud-woocommerce', [
            'title' => 'WooCommerce Hosting — Datanito Cloud',
            'meta_description' => 'WooCommerce-optimized hosting with caching, CDN, and checkout reliability.',
            'section_tag' => 'Cloud',
        ]);
    }

    public function cloudWp(): string
    {
        return $this->view('pages/cloud-wordpress', [
            'title' => 'WordPress Hosting — Datanito Cloud',
            'meta_description' => 'Managed WordPress hosting with staging, backups, security, and performance tuning.',
            'section_tag' => 'Cloud',
        ]);
    }

    public function quantaStudio(): string
    {
        return $this->view('pages/quanta-studio', [
            'title' => 'Quanta AI Studio — build agents',
            'meta_description' => 'Design custom AI agents and workflows with Quanta AI Studio and enterprise integrations.',
            'section_tag' => 'Quanta AI',
        ]);
    }

    public function solutions(): string
    {
        return $this->view('pages/solutions/index', [
            'title' => 'Solutions — web, SEO, apps, ads, WordPress support',
            'meta_description' => 'Full-service solutions: web design, SEO, app development, digital ads, WordPress premium support.',
            'section_tag' => 'Solutions',
        ]);
    }

    public function solutionWeb(): string
    {
        return $this->view('pages/solutions/web-design', [
            'title' => 'Web Design Services',
            'meta_description' => 'Web design packages for startup, business, enterprise, eCommerce, custom with UX-first delivery.',
            'section_tag' => 'Solutions',
        ]);
    }

    public function solutionSeo(): string
    {
        return $this->view('pages/solutions/seo', [
            'title' => 'SEO Services',
            'meta_description' => 'On-page, off-page, technical, content, and international SEO with case studies.',
            'section_tag' => 'Solutions',
        ]);
    }

    public function solutionApp(): string
    {
        return $this->view('pages/solutions/app-dev', [
            'title' => 'App Development Services',
            'meta_description' => 'Web and mobile app development, PWAs, backend integration, and industry-specialized builds.',
            'section_tag' => 'Solutions',
        ]);
    }

    public function solutionAds(): string
    {
        return $this->view('pages/solutions/digital-ads', [
            'title' => 'Digital Advertising',
            'meta_description' => 'Google/Meta ads strategy, creative, optimization, analytics, conversion tracking.',
            'section_tag' => 'Solutions',
        ]);
    }

    public function solutionWp(): string
    {
        return $this->view('pages/solutions/wp-support', [
            'title' => 'WordPress Premium Support',
            'meta_description' => 'Maintenance, security, performance, backups, and emergency fixes for WordPress sites.',
            'section_tag' => 'Solutions',
        ]);
    }

    public function pay(): string
    {
        return $this->view('pages/pay', [
            'title' => 'Datanito Pay — accept global payments',
            'meta_description' => 'Accept Visa, MasterCard, AmEx with Datanito Pay. Multi-step merchant application and compliance.',
            'section_tag' => 'Pay',
        ]);
    }

    public function blog(): string
    {
        return $this->view('pages/blog', [
            'title' => 'Blog — insights & updates',
            'meta_description' => 'Datanito blog with insights on cloud, AI, payments, and growth.',
            'section_tag' => 'Blog',
        ]);
    }

    public function blogPost(): string
    {
        return $this->view('pages/blog-single', [
            'title' => 'Blog post — sample',
            'meta_description' => 'Single blog post layout with related posts and reading progress concept.',
            'section_tag' => 'Blog',
        ]);
    }

    public function about(): string
    {
        return $this->view('pages/about', [
            'title' => 'About — international AI and software company',
            'meta_description' => 'Learn about Datanito: mission, global presence, leadership, and certifications.',
            'section_tag' => 'Company',
        ]);
    }

    public function contact(): string
    {
        return $this->view('pages/contact', [
            'title' => 'Contact — get in touch',
            'meta_description' => 'Reach Datanito sales or support with spam-protected forms and fast response.',
            'section_tag' => 'Company',
        ]);
    }

    public function privacy(): string
    {
        return $this->view('pages/privacy', [
            'title' => 'Privacy Policy',
            'meta_description' => 'Privacy policy covering data collection, AI data handling, and user rights.',
            'section_tag' => 'Company',
        ]);
    }

    public function terms(): string
    {
        return $this->view('pages/terms', [
            'title' => 'Terms & Conditions',
            'meta_description' => 'Terms for Datanito services: cloud, domains, AI, and payments.',
            'section_tag' => 'Company',
        ]);
    }

    public function login(): string
    {
        return $this->view('pages/auth/login', [
            'title' => 'Login',
            'meta_description' => 'Login with email/password, Google, or SMS OTP (TR).',
            'section_tag' => 'Account',
        ]);
    }

    public function signup(): string
    {
        return $this->view('pages/auth/signup', [
            'title' => 'Create account',
            'meta_description' => 'Create your Datanito account with locale, currency, and security checks.',
            'section_tag' => 'Account',
        ]);
    }

    public function dashboard(): string
    {
        return $this->view('pages/dashboard', [
            'title' => 'Dashboard — overview',
            'meta_description' => 'Customer dashboard for cloud, domains, pay, Quanta, invoices, and tickets.',
            'section_tag' => 'Dashboard',
        ]);
    }

    public function quantaChat(): string
    {
        return $this->view('pages/quanta-chat', [
            'title' => 'Quanta Chat — dedicated experience',
            'meta_description' => 'Quanta Chat with model selector, memory, agents, and polished chat UI.',
            'section_tag' => 'Quanta AI',
        ]);
    }

    public function plans(): string
    {
        return $this->view('pages/plans', [
            'title' => 'Plans — Free, Go, Plus, Pro, Business',
            'meta_description' => 'Compare Datanito plans with limits, support, AI access, and payment discounts.',
            'section_tag' => 'Plans',
        ]);
    }

    public function cart(): string
    {
        return $this->view('pages/cart', [
            'title' => 'Cart',
            'meta_description' => 'Review items across domains, hosting, AI, and payments before checkout.',
            'section_tag' => 'Commerce',
        ]);
    }

    public function checkout(): string
    {
        return $this->view('pages/checkout', [
            'title' => 'Checkout',
            'meta_description' => 'Multi-step checkout for details, payment, and review with Datanito Pay.',
            'section_tag' => 'Commerce',
        ]);
    }

    public function invoices(): string
    {
        return $this->view('pages/invoices', [
            'title' => 'Invoices & Billing',
            'meta_description' => 'Invoices with status, payments, PDFs, reminders, and automation concepts.',
            'section_tag' => 'Billing',
        ]);
    }

    public function support(): string
    {
        return $this->view('pages/support', [
            'title' => 'Support & Tickets',
            'meta_description' => 'Tickets list and threads with attachments, categories, and status controls.',
            'section_tag' => 'Support',
        ]);
    }

    public function admin(): string
    {
        return $this->view('pages/admin', [
            'title' => 'Admin Panel',
            'meta_description' => 'Admin CRM-like area for users, services, billing, tickets, emails, SMS, and logs.',
            'section_tag' => 'Admin',
        ]);
    }
}
