<?php

namespace App\Controllers;

use App\Services\HostingService;

class HostingController extends BaseController
{
    private HostingService $service;

    public function __construct()
    {
        $this->service = new HostingService();
    }

    public function create(): string
    {
        $domain = $_POST['domain'] ?? '';
        $plan = $_POST['plan'] ?? '';
        if (!$domain || !$plan) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Domain and plan required']);
        }
        $result = $this->service->createAccount($domain, $plan);
        return json_encode(['status' => 'ok', 'data' => $result]);
    }

    public function suspend(): string
    {
        $domain = $_POST['domain'] ?? '';
        if (!$domain) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Domain required']);
        }
        $result = $this->service->suspendAccount($domain);
        return json_encode(['status' => 'ok', 'data' => $result]);
    }

    public function terminate(): string
    {
        $domain = $_POST['domain'] ?? '';
        if (!$domain) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Domain required']);
        }
        $result = $this->service->terminateAccount($domain);
        return json_encode(['status' => 'ok', 'data' => $result]);
    }

    public function resetPassword(): string
    {
        $domain = $_POST['domain'] ?? '';
        if (!$domain) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Domain required']);
        }
        $result = $this->service->resetPassword($domain);
        return json_encode(['status' => 'ok', 'data' => $result]);
    }
}
