<?php

namespace App\Controllers;

class FormController extends BaseController
{
    private string $logDir;

    public function __construct()
    {
        $this->logDir = __DIR__ . '/../../logs';
        if (!is_dir($this->logDir)) {
            mkdir($this->logDir, 0777, true);
        }
    }

    public function contact(): string
    {
        $data = $this->sanitize([
            'name' => $_POST['name'] ?? '',
            'email' => $_POST['email'] ?? '',
            'region' => $_POST['region'] ?? '',
            'interest' => $_POST['interest'] ?? '',
            'message' => $_POST['message'] ?? '',
            'honeypot' => $_POST['hp'] ?? '',
        ]);

        if ($data['honeypot']) {
            return $this->spamResponse();
        }

        if (!$data['name'] || !$data['email'] || !$data['message']) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Required fields missing']);
        }

        $this->log('contact.log', $data);
        return json_encode(['status' => 'ok', 'message' => 'Received']);
    }

    public function applyPay(): string
    {
        $data = $this->sanitize([
            'business' => $_POST['business'] ?? '',
            'website' => $_POST['website'] ?? '',
            'volume' => $_POST['volume'] ?? '',
            'kyc' => $_POST['kyc'] ?? '',
            'honeypot' => $_POST['hp'] ?? '',
        ]);

        if ($data['honeypot']) {
            return $this->spamResponse();
        }

        if (!$data['business'] || !$data['website']) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Required fields missing']);
        }

        $this->log('pay-applications.log', $data);
        return json_encode(['status' => 'ok', 'message' => 'Application received']);
    }

    public function customCloud(): string
    {
        $data = $this->sanitize([
            'company' => $_POST['company'] ?? '',
            'contact' => $_POST['contact'] ?? '',
            'traffic' => $_POST['traffic'] ?? '',
            'needs' => $_POST['needs'] ?? '',
            'honeypot' => $_POST['hp'] ?? '',
        ]);

        if ($data['honeypot']) {
            return $this->spamResponse();
        }

        if (!$data['company'] || !$data['contact']) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Required fields missing']);
        }

        $this->log('custom-cloud.log', $data);
        return json_encode(['status' => 'ok', 'message' => 'Request submitted']);
    }

    private function sanitize(array $data): array
    {
        return array_map(fn($v) => trim(strip_tags((string) $v)), $data);
    }

    private function log(string $file, array $data): void
    {
        $line = date('c') . ' ' . json_encode($data) . PHP_EOL;
        file_put_contents($this->logDir . '/' . $file, $line, FILE_APPEND);
    }

    private function spamResponse(): string
    {
        http_response_code(200);
        return json_encode(['status' => 'ok', 'message' => 'Received']);
    }
}
