<?php

namespace App\Controllers;

class ErrorController extends BaseController
{
    public function notFound(string $path = ''): string
    {
        http_response_code(404);
        return $this->view('pages/404', [
            'title' => 'Page not found',
            'meta_description' => 'The page you are looking for is not available.',
            'missing_path' => $path,
            'section_tag' => 'Error',
        ]);
    }
}
