<?php

namespace App\Controllers;

use App\Services\PayService;

class CheckoutController extends BaseController
{
    private PayService $pay;

    public function __construct()
    {
        $this->pay = new PayService();
    }

    public function pay(): string
    {
        $payload = [
            'amount' => $_POST['amount'] ?? '',
            'currency' => $_POST['currency'] ?? 'USD',
            'items' => $this->decodeItems($_POST['items'] ?? '[]'),
        ];

        if (!$payload['amount']) {
            http_response_code(400);
            return json_encode(['status' => 'error', 'message' => 'Amount required']);
        }

        $result = $this->pay->initiatePayment($payload);
        return json_encode(['status' => 'ok', 'data' => $result]);
    }

    private function decodeItems(string $items): array
    {
        $decoded = json_decode($items, true);
        return is_array($decoded) ? $decoded : [];
    }
}
