<?php

namespace App\Controllers;

class BaseController
{
    protected string $layout = __DIR__ . '/../Views/layouts/main.php';

    protected function view(string $view, array $data = []): string
    {
        $viewFile = __DIR__ . '/../Views/' . $view . '.php';
        if (!file_exists($viewFile)) {
            http_response_code(500);
            return "View not found: {$view}";
        }

        extract($data);
        ob_start();
        include $viewFile;
        $content = ob_get_clean();

        if (!file_exists($this->layout)) {
            return $content;
        }

        ob_start();
        include $this->layout;
        return ob_get_clean();
    }
}
