## Datanito 2026 UX skeleton

Mobile-first iOS 26-inspired scaffolding with PHP router, Tailwind/Flowbite CDN, and AI/Gemini placeholders.

### Structure
- `public/` — front controller, assets, `.htaccess` rewrite.
- `app/Core` — Router.
- `app/Controllers` — page controllers.
- `app/Views` — layouts + page stubs.
- `resources/lang/{tr,en,de,fr}` — translations (extend as needed).
- `config/app.php` — locales, currencies, defaults.
- `.env.example` — env placeholders including `GEMINI_BACKEND_API_KEY`.

### Run locally
```bash
php -S localhost:8000 -t public
```

### Next steps
- Flesh out each page with real content, structured data, and validated forms.
- Connect Gemini API in backend services for domain assistant + Quanta.
- Add WHM/cPanel service clients and admin/dashboard actions.
